/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.control;

import java.text.ParseException;
import org.roastlogger.control.UserInputHolder;
import org.roastlogger.datastructures.Note;
import org.roastlogger.datastructures.NoteVector;

public class DataController {
    private NoteVector noteHolder;
    private int position;

    public DataController() {
        this.noteHolder = new NoteVector();
        this.position = 0;
    }

    public DataController(NoteVector nv) {
        this.setNoteVector(nv);
        this.position = 0;
    }

    public void setNoteVector(NoteVector nv) {
        this.noteHolder = nv;
    }

    private Note parseNote(UserInputHolder uih) throws ParseException {
        int seconds;
        int minutes;
        Note newNote = new Note(this.noteHolder.size());
        String uihDate = uih.getDate();
        String uihType = uih.getType();
        String uihMass = uih.getMass();
        String uihFirst = uih.getFirst();
        String uihSecond = uih.getSecond();
        String uihTotal = uih.getTotal();
        String uihRoast = uih.getRoast();
        String uihTaste = uih.getTaste();
        if (uihDate.equals("") || uihDate == null) {
            throw new ParseException("empty", 0);
        }
        try {
            newNote.setDate(uihDate);
        }
        catch (ParseException pe) {
            throw new ParseException("invalid", 0);
        }
        if (uihType.equals("") || uihType == null) {
            throw new ParseException("empty", 1);
        }
        newNote.setType(uihType);
        if (uihMass.equals("") || uihMass == null) {
            throw new ParseException("empty", 2);
        }
        try {
            newNote.setMass(uihMass);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("invalid", 2);
        }
        if (uihFirst.equals("") || uihFirst == null) {
            throw new ParseException("empty", 3);
        }
        int indexOfColon = uihFirst.indexOf(":");
        if (indexOfColon == -1) {
            throw new ParseException("invalid", 3);
        }
        String mins = uihFirst.substring(0, indexOfColon);
        String secs = uihFirst.substring(indexOfColon + 1, uihFirst.length());
        try {
            minutes = Integer.parseInt(mins) * 60;
            seconds = Integer.parseInt(secs) + minutes;
            newNote.setFirst(new Integer(seconds).toString());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("invalid", 3);
        }
        if (!uihSecond.equals("") && uihSecond != null) {
            indexOfColon = uihSecond.indexOf(":");
            if (indexOfColon == -1) {
                throw new ParseException("invalid", 4);
            }
            mins = uihSecond.substring(0, indexOfColon);
            secs = uihSecond.substring(indexOfColon + 1, uihSecond.length());
            try {
                minutes = Integer.parseInt(mins) * 60;
                seconds = Integer.parseInt(secs) + minutes;
                newNote.setSecond(new Integer(seconds).toString());
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("invalid", 4);
            }
        }
        if (uihTotal.equals("") || uihTotal == null) {
            throw new ParseException("empty", 5);
        }
        indexOfColon = uihTotal.indexOf(":");
        if (indexOfColon == -1) {
            throw new ParseException("invalid", 5);
        }
        mins = uihTotal.substring(0, indexOfColon);
        secs = uihTotal.substring(indexOfColon + 1, uihTotal.length());
        try {
            minutes = Integer.parseInt(mins) * 60;
            seconds = Integer.parseInt(secs) + minutes;
            newNote.setStop(new Integer(seconds).toString());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("invalid", 5);
        }
        if (!uihRoast.equals("") && uihRoast != null) {
            newNote.setRoastNote(uihRoast);
        }
        if (!uihTaste.equals("") && uihRoast != null) {
            newNote.setTasteNote(uihTaste);
        }
        return newNote;
    }

    public Note addNote(UserInputHolder uih) throws ParseException {
        Note newNote = this.parseNote(uih);
        this.noteHolder.add(newNote);
        return newNote;
    }

    public Note editNote(UserInputHolder uih, Note oldNote) throws ParseException {
        Note newNote = this.parseNote(uih);
        newNote.setIndex(oldNote.getIndex());
        this.noteHolder.set(oldNote.getIndex(), newNote);
        return newNote;
    }

    public NoteVector newFile() {
        this.noteHolder = new NoteVector();
        return this.noteHolder;
    }

    public void deleteNote(Note n) {
        this.noteHolder.remove(n.getIndex());
    }

    public void newSearch() {
        this.position = 0;
    }

    public Note findNext(UserInputHolder uih) throws IllegalArgumentException, NumberFormatException {
        while (this.position < this.noteHolder.size()) {
            block8: {
                boolean tasteEntered;
                String uihTaste;
                boolean roastEntered;
                String uihRoast;
                Note current;
                block9: {
                    current = (Note)this.noteHolder.get(this.position);
                    String uihType = uih.getType();
                    boolean typeEntered = uihType != null && !uihType.equals("");
                    String uihMass = uih.getMass();
                    boolean massEntered = uihMass != null && !uihMass.equals("");
                    uihRoast = uih.getRoast();
                    roastEntered = uihRoast != null && !uihRoast.equals("");
                    uihTaste = uih.getTaste();
                    boolean bl = tasteEntered = uihTaste != null && !uihTaste.equals("");
                    if (!(typeEntered || massEntered || roastEntered || tasteEntered)) {
                        throw new IllegalArgumentException("No search criteria entered");
                    }
                    if (typeEntered && current.getType().toLowerCase().indexOf(uihType.toLowerCase()) == -1) break block8;
                    if (!massEntered) break block9;
                    int massInt = -1;
                    massInt = Integer.parseInt(uihMass);
                    if (massInt != current.getMass()) break block8;
                }
                if (!(roastEntered && current.getRoast().indexOf(uihRoast) == -1 || tasteEntered && current.getTaste().toLowerCase().indexOf(uihTaste.toLowerCase()) == -1)) {
                    ++this.position;
                    return current;
                }
            }
            ++this.position;
        }
        return null;
    }
}

