/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.control;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.roastlogger.control.UserInputHolder;
import org.roastlogger.datastructures.Note;
import org.roastlogger.datastructures.NoteVector;
import org.roastlogger.xmlio.LogReader;
import org.roastlogger.xmlio.LogWriter;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IOController {
    private LogReader logReader = new LogReader();
    private LogWriter logWriter = new LogWriter();
    private boolean modified = false;
    private boolean inWebMode = false;
    private String fileName = "";

    public NoteVector openFile(UserInputHolder uih) throws SAXParseException, SAXException, ParserConfigurationException, IOException, IllegalArgumentException {
        NoteVector nv;
        boolean remote;
        String url;
        boolean valid = uih.getFileLocation().equals("") ^ uih.getWebLocation().equals("");
        if (!valid) {
            throw new IllegalArgumentException("You must enter either a local or remote location.");
        }
        if (uih.getFileLocation().equals("")) {
            url = uih.getWebLocation();
            remote = true;
        } else {
            url = uih.getFileLocation();
            remote = false;
        }
        try {
            nv = this.logReader.getNotes(url);
        }
        catch (SAXParseException spe) {
            throw spe;
        }
        catch (SAXException se) {
            throw se;
        }
        catch (ParserConfigurationException pce) {
            throw pce;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        this.fileName = url;
        this.modified = false;
        this.inWebMode = remote;
        return nv;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String url) {
        this.fileName = url;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean b) {
        this.modified = b;
    }

    public boolean webMode() {
        return this.inWebMode;
    }

    public void setWebMode(boolean urlIsRemote) {
        this.inWebMode = urlIsRemote;
    }

    public void saveFile(NoteVector nv) throws FileNotFoundException, IOException {
        if (this.fileName.equals("")) {
            throw new FileNotFoundException("no filename given");
        }
        if (this.inWebMode) {
            throw new IOException("you cannot save a file over http");
        }
        LogWriter lw = new LogWriter();
        lw.openFile(this.fileName);
        this.getClass().getClassLoader();
        URL dtdURL = ClassLoader.getSystemResource("xmldata/roastlog.dtd");
        lw.writeHeader(dtdURL.toString());
        for (int i = 0; i < nv.size(); ++i) {
            lw.writeNote((Note)nv.get(i));
        }
        lw.writeFooter();
        lw.closeFile();
        this.modified = false;
    }

    public void publishFile(NoteVector nv, UserInputHolder uih) throws IOException, FileNotFoundException {
        String fileName = uih.getFileLocation();
        if (fileName.equals("")) {
            throw new FileNotFoundException("no filename given");
        }
        if (this.inWebMode) {
            throw new IOException("you cannot save a file over http");
        }
        LogWriter lw = new LogWriter();
        lw.openFile(fileName);
        lw.writeHeader("http://roastlogger.sourceforge.net/roastlog/roastlog.dtd");
        for (int i = 0; i < nv.size(); ++i) {
            lw.writeNote((Note)nv.get(i));
        }
        lw.writeFooter();
        lw.closeFile();
        this.modified = false;
    }
}

