/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.datastructures;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Note {
    private int idx;
    private Date date;
    private String shortDateString;
    private String longDateString;
    private String type;
    private int mass;
    private int first;
    private int second;
    private int stop;
    private String roastNote;
    private String tasteNote;

    public Note(int indexNumber) {
        this.idx = indexNumber;
        this.mass = -1;
        this.first = -1;
        this.second = -1;
        this.stop = -1;
        this.roastNote = "";
        this.tasteNote = "";
    }

    public int getIndex() {
        return this.idx;
    }

    public void setIndex(int newIndex) {
        this.idx = newIndex;
    }

    public Date getDate() {
        return this.date;
    }

    public String getShortDateString() {
        return this.shortDateString;
    }

    public String getLongDateString() {
        return this.longDateString;
    }

    public void setDate(String textPattern) throws ParseException {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd");
        dateFormatter.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        this.date = dateFormatter.parse(textPattern, pos);
        if (this.date == null) {
            throw new ParseException("Invalid date format, must be yyyy/MM/dd", pos.getIndex());
        }
        this.shortDateString = dateFormatter.format(this.date);
        dateFormatter = new SimpleDateFormat("EEE d MMM yyyy");
        this.longDateString = dateFormatter.format(this.date);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String beanType) {
        this.type = beanType;
    }

    public int getMass() {
        return this.mass;
    }

    public void setMass(String roastMassString) throws NumberFormatException {
        int roastMass = Integer.parseInt(roastMassString);
        this.mass = roastMass;
    }

    public int getFirst() {
        return this.first;
    }

    public void setFirst(String timeString) throws NumberFormatException {
        int time = Integer.parseInt(timeString);
        this.first = time;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(String timeString) throws NumberFormatException {
        int time = Integer.parseInt(timeString);
        this.second = time;
    }

    public int getStop() {
        return this.stop;
    }

    public void setStop(String totalTimeString) throws NumberFormatException {
        int totalTime = Integer.parseInt(totalTimeString);
        this.stop = totalTime;
    }

    public String getRoast() {
        return this.roastNote;
    }

    public void setRoastNote(String note) {
        this.roastNote = note;
    }

    public String getTaste() {
        return this.tasteNote;
    }

    public void setTasteNote(String note) {
        this.tasteNote = note;
    }

    public String toString() {
        return this.shortDateString;
    }
}

