/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.roastlogger.control.UserInputHolder;
import org.roastlogger.datastructures.Note;

public class EditDialog
extends JDialog
implements ActionListener,
FocusListener,
KeyListener {
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    private int option = -1;
    private UserInputHolder inputHolder;
    private boolean goAhead;
    private boolean totalReached;
    private Container pane;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JPanel topMainPanel;
    private JPanel bottomMainPanel;
    private JLabel titleLabel;
    private JLabel dateLabel;
    private JLabel typeLabel;
    private JLabel massLabel;
    private JLabel firstLabel;
    private JLabel secondLabel;
    private JLabel totalLabel;
    private JLabel roastLabel;
    private JLabel tasteLabel;
    private JTextField dateTextField;
    private JTextField typeTextField;
    private JTextField massTextField;
    private JTextField firstTextField;
    private JTextField secondTextField;
    private JTextField totalTextField;
    private JScrollPane roastScrollPane;
    private JScrollPane tasteScrollPane;
    private JTextPane roastTextPane;
    private JTextPane tasteTextPane;
    private JButton okButton;
    private JButton cancelButton;

    public EditDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.goAhead = false;
        this.totalReached = false;
        this.inputHolder = new UserInputHolder();
        this.initComponents();
    }

    public EditDialog(Frame parent, boolean modal, Note note) {
        super(parent, modal);
        this.inputHolder = new UserInputHolder();
        this.initComponents();
        this.okButton.setEnabled(true);
        this.setFields(note);
    }

    private void initComponents() {
        this.pane = this.getContentPane();
        this.mainPanel = new JPanel();
        this.topMainPanel = new JPanel();
        this.bottomMainPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.dateLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.massLabel = new JLabel();
        this.firstLabel = new JLabel();
        this.secondLabel = new JLabel();
        this.totalLabel = new JLabel();
        this.roastLabel = new JLabel();
        this.tasteLabel = new JLabel();
        this.dateTextField = new JTextField();
        this.dateTextField.addFocusListener(this);
        this.typeTextField = new JTextField();
        this.typeTextField.addFocusListener(this);
        this.massTextField = new JTextField();
        this.massTextField.addFocusListener(this);
        this.firstTextField = new JTextField();
        this.firstTextField.addFocusListener(this);
        this.secondTextField = new JTextField();
        this.totalTextField = new JTextField();
        this.totalTextField.addFocusListener(this);
        this.totalTextField.addKeyListener(this);
        this.roastScrollPane = new JScrollPane();
        this.roastTextPane = new JTextPane();
        this.tasteScrollPane = new JScrollPane();
        this.tasteTextPane = new JTextPane();
        this.okButton = new JButton();
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton();
        this.pane.setLayout(new BorderLayout(0, 5));
        this.setTitle("Enter Roast Details");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditDialog.this.option = 0;
                EditDialog.this.closeDialog();
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("Roast Details");
        this.pane.add((Component)this.titleLabel, "North");
        this.mainPanel.setLayout(new BorderLayout(0, 5));
        this.mainPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 5)));
        this.topMainPanel.setLayout(new GridLayout(6, 2, 0, 5));
        this.dateLabel.setHorizontalAlignment(0);
        this.dateLabel.setText("Date: (yyyy/mm/dd)");
        this.topMainPanel.add(this.dateLabel);
        this.topMainPanel.add(this.dateTextField);
        this.typeLabel.setHorizontalAlignment(0);
        this.typeLabel.setText("Type:");
        this.topMainPanel.add(this.typeLabel);
        this.topMainPanel.add(this.typeTextField);
        this.massLabel.setHorizontalAlignment(0);
        this.massLabel.setText("Mass: (in grams)");
        this.topMainPanel.add(this.massLabel);
        this.topMainPanel.add(this.massTextField);
        this.firstLabel.setHorizontalAlignment(0);
        this.firstLabel.setText("First Crack: (min:secs)");
        this.topMainPanel.add(this.firstLabel);
        this.topMainPanel.add(this.firstTextField);
        this.secondLabel.setHorizontalAlignment(0);
        this.secondLabel.setText("Second Crack: (min:secs)");
        this.topMainPanel.add(this.secondLabel);
        this.topMainPanel.add(this.secondTextField);
        this.totalLabel.setHorizontalAlignment(0);
        this.totalLabel.setText("Total Time: (min:secs)");
        this.topMainPanel.add(this.totalLabel);
        this.topMainPanel.add(this.totalTextField);
        this.mainPanel.add((Component)this.topMainPanel, "North");
        this.bottomMainPanel.setLayout(new GridLayout(2, 2, 0, 5));
        this.roastLabel.setHorizontalAlignment(0);
        this.roastLabel.setText("Roast Notes:");
        this.bottomMainPanel.add(this.roastLabel);
        this.roastScrollPane.setViewportView(this.roastTextPane);
        this.bottomMainPanel.add(this.roastScrollPane);
        this.tasteLabel.setHorizontalAlignment(0);
        this.tasteLabel.setText("Taste Notes:");
        this.bottomMainPanel.add(this.tasteLabel);
        this.tasteScrollPane.setViewportView(this.tasteTextPane);
        this.bottomMainPanel.add(this.tasteScrollPane);
        this.mainPanel.add((Component)this.bottomMainPanel, "Center");
        this.pane.add((Component)this.mainPanel, "Center");
        this.okButton.setText("Ok");
        this.okButton.addActionListener(this);
        this.bottomPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.bottomPanel.add(this.cancelButton);
        this.pane.add((Component)this.bottomPanel, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 415) / 2, (screenSize.height - 425) / 2, 415, 425);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.option;
    }

    public UserInputHolder getInput() {
        return this.inputHolder;
    }

    private void setFields(Note note) {
        this.dateTextField.setEditable(false);
        this.dateTextField.setText(note.getShortDateString());
        this.typeTextField.setText(note.getType());
        this.massTextField.setText(new Integer(note.getMass()).toString());
        int minutes = note.getFirst() / 60;
        int seconds = note.getFirst() % 60;
        String firstString = minutes + ":" + seconds + (seconds < 10 ? "0" : "");
        this.firstTextField.setText(firstString);
        if (note.getSecond() != -1) {
            minutes = note.getSecond() / 60;
            seconds = note.getSecond() % 60;
            String secondString = minutes + ":" + seconds + (seconds < 10 ? "0" : "");
            this.secondTextField.setText(secondString);
        } else {
            this.secondTextField.setText("");
        }
        minutes = note.getStop() / 60;
        seconds = note.getStop() % 60;
        String stopString = minutes + ":" + seconds + (seconds < 10 ? "0" : "");
        this.totalTextField.setText(stopString);
        this.roastTextPane.setText(note.getRoast());
        this.tasteTextPane.setText(note.getTaste());
    }

    public void actionPerformed(ActionEvent evt) {
        Object eventSource = evt.getSource();
        if (eventSource.equals(this.okButton)) {
            this.option = 1;
            this.inputHolder.setDate(this.dateTextField.getText());
            this.inputHolder.setType(this.typeTextField.getText());
            this.inputHolder.setMass(this.massTextField.getText());
            this.inputHolder.setFirst(this.firstTextField.getText());
            this.inputHolder.setSecond(this.secondTextField.getText());
            this.inputHolder.setTotal(this.totalTextField.getText());
            this.inputHolder.setRoast(this.roastTextPane.getText());
            this.inputHolder.setTaste(this.tasteTextPane.getText());
            this.setVisible(false);
        } else {
            this.option = 0;
            this.closeDialog();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        boolean bl = this.goAhead = !this.dateTextField.getText().equals("") && !this.typeTextField.getText().equals("") && !this.massTextField.getText().equals("") && !this.firstTextField.getText().equals("");
        if (this.totalReached) {
            if (this.goAhead && !this.totalTextField.getText().equals("")) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        this.totalReached = true;
        if (this.goAhead) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }
}

