/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.roastlogger.control.UserInputHolder;
import org.roastlogger.gui.XMLFileFilter;

public class FileDialog
extends JDialog
implements ActionListener {
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    UserInputHolder inputHolder = new UserInputHolder();
    private String fileURL;
    private int option = -1;
    private Container pane;
    private JPanel panel1;
    private JPanel panel2;
    private JPanel panel3;
    private JPanel panel4;
    private JLabel fileLocationLabel;
    private JLabel orLabel;
    private JLabel webLocationLabel;
    private JTextField fileLocationTextField;
    private JTextField webLocationTextField;
    private JButton browseButton;
    private JButton okButton;
    private JButton cancelButton;

    public FileDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.pane = this.getContentPane();
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.panel3 = new JPanel();
        this.panel4 = new JPanel();
        this.fileLocationLabel = new JLabel();
        this.orLabel = new JLabel();
        this.webLocationLabel = new JLabel();
        this.fileLocationTextField = new JTextField();
        this.webLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.pane.setLayout(new BoxLayout(this.pane, 1));
        this.setTitle("Choose File...");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FileDialog.this.option = 0;
                FileDialog.this.closeDialog();
            }
        });
        this.panel1.setLayout(new FlowLayout(0));
        this.fileLocationLabel.setText("Enter File Location: ");
        this.panel1.add(this.fileLocationLabel);
        this.fileLocationTextField.setPreferredSize(new Dimension(250, 20));
        this.panel1.add(this.fileLocationTextField);
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(this);
        this.panel1.add(this.browseButton);
        this.pane.add(this.panel1);
        this.panel2.setLayout(new FlowLayout(0));
        this.orLabel.setText("Or...");
        this.panel2.add(this.orLabel);
        this.pane.add(this.panel2);
        this.panel3.setLayout(new FlowLayout(0));
        this.webLocationLabel.setText("Enter Web Location: ");
        this.panel3.add(this.webLocationLabel);
        this.webLocationTextField.setPreferredSize(new Dimension(250, 20));
        this.panel3.add(this.webLocationTextField);
        this.pane.add(this.panel3);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(this);
        this.panel4.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.panel4.add(this.cancelButton);
        this.pane.add(this.panel4);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 480) / 2, (screenSize.height - 170) / 2, 480, 170);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.option;
    }

    public UserInputHolder getInput() {
        return this.inputHolder;
    }

    public void actionPerformed(ActionEvent evt) {
        Object eventSource = evt.getSource();
        if (eventSource.equals(this.browseButton)) {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(new XMLFileFilter());
            fc.setAcceptAllFileFilterUsed(false);
            int retVal = fc.showOpenDialog(this);
            if (retVal == 0) {
                this.fileURL = fc.getSelectedFile().getAbsolutePath();
                this.fileLocationTextField.setText(this.fileURL);
            }
        } else if (eventSource.equals(this.okButton)) {
            boolean bothEntered;
            this.option = 1;
            String fileLocation = this.fileLocationTextField.getText();
            String webLocation = this.webLocationTextField.getText();
            boolean bothEmpty = fileLocation.equals("") && webLocation.equals("");
            boolean bl = bothEntered = !fileLocation.equals("") && !webLocation.equals("");
            if (bothEmpty || bothEntered) {
                JOptionPane.showMessageDialog(this, "You must enter EITHER a local or remote location", "Error", 0);
            } else {
                this.inputHolder.setFileLocation(fileLocation);
                this.inputHolder.setWebLocation(webLocation);
                this.setVisible(false);
            }
        } else if (eventSource.equals(this.cancelButton)) {
            this.option = 0;
            this.closeDialog();
        }
    }
}

