/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.roastlogger.control.DataController;
import org.roastlogger.control.IOController;
import org.roastlogger.datastructures.Note;
import org.roastlogger.datastructures.NoteVector;
import org.roastlogger.gui.AboutDialog;
import org.roastlogger.gui.EditDialog;
import org.roastlogger.gui.FileDialog;
import org.roastlogger.gui.PublishDialog;
import org.roastlogger.gui.SearchDialog;
import org.roastlogger.gui.ViewDialog;
import org.roastlogger.gui.XMLFileFilter;
import org.roastlogger.gui.tree.RoastTreeNode;
import org.roastlogger.gui.tree.TreeBuilder;

public class Main
extends JFrame
implements ActionListener,
TreeSelectionListener {
    private JSplitPane jSplitPane;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JPanel topInnerPanel;
    private JPanel bottomInnerPanel;
    private JLabel dateLabel;
    private JLabel massLabel;
    private JLabel typeLabel;
    private JLabel firstLabel;
    private JLabel secondLabel;
    private JLabel totalLabel;
    private JLabel roastLabel;
    private JLabel tasteLabel;
    private JTextField dateField;
    private JTextField massField;
    private JTextField typeField;
    private JTextField firstField;
    private JTextField secondField;
    private JTextField totalField;
    private JTextField roastField;
    private JTextField tasteField;
    private JMenuBar menuBar;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JMenu fileMenu;
    private JMenuItem newFileMenuItem;
    private JMenuItem newNoteMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem publishMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu editMenu;
    private JMenuItem editMenuItem;
    private JMenuItem searchMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu viewMenu;
    private JMenuItem noteMenuItem;
    private JMenu helpMenu;
    private JMenuItem contentsMenuItem;
    private JMenuItem aboutMenuItem;
    private JScrollPane treeScroller;
    private JTree jTree1;
    private JScrollPane roastScrollPane;
    private JTextPane roastTextPane;
    private JScrollPane tasteScrollPane;
    private JTextPane tasteTextPane;
    private DataController dataController;
    private IOController ioController = new IOController();
    private NoteVector holder;
    private TreeBuilder treeBuilder;

    public Main() {
        this.dataController = new DataController();
        this.holder = new NoteVector();
        this.dataController = new DataController(this.holder);
        this.treeBuilder = new TreeBuilder(this.holder);
        this.initComponents();
    }

    private void initComponents() {
        Container pane = this.getContentPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newNoteMenuItem = new JMenuItem();
        this.newFileMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.openMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.publishMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.editMenuItem = new JMenuItem();
        this.searchMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.noteMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.jSplitPane = new JSplitPane();
        this.topPanel = new JPanel();
        this.treeScroller = new JScrollPane();
        this.jTree1 = this.treeBuilder.getTree();
        this.jTree1.addTreeSelectionListener(this);
        this.bottomPanel = new JPanel();
        this.topInnerPanel = new JPanel();
        this.dateLabel = new JLabel();
        this.dateField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeField = new JTextField();
        this.massLabel = new JLabel();
        this.massField = new JTextField();
        this.firstLabel = new JLabel();
        this.firstField = new JTextField();
        this.secondLabel = new JLabel();
        this.secondField = new JTextField();
        this.totalLabel = new JLabel();
        this.totalField = new JTextField();
        this.bottomInnerPanel = new JPanel();
        this.roastLabel = new JLabel();
        this.roastScrollPane = new JScrollPane();
        this.roastTextPane = new JTextPane();
        this.tasteLabel = new JLabel();
        this.tasteScrollPane = new JScrollPane();
        this.tasteTextPane = new JTextPane();
        pane.setLayout(new BoxLayout(pane, 0));
        this.setTitle("RoastLogger");
        this.setCursor(new Cursor(0));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Main.this.doExit();
            }
        });
        this.fileMenu.setText("File");
        this.newNoteMenuItem.setText("New Note");
        this.newNoteMenuItem.addActionListener(this);
        this.fileMenu.add(this.newNoteMenuItem);
        this.newFileMenuItem.setText("New File");
        this.newFileMenuItem.addActionListener(this);
        this.fileMenu.add(this.newFileMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(this);
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(this);
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save As ...");
        this.saveAsMenuItem.addActionListener(this);
        this.fileMenu.add(this.saveAsMenuItem);
        this.publishMenuItem.setText("Publish on web");
        this.publishMenuItem.addActionListener(this);
        this.fileMenu.add(this.publishMenuItem);
        this.fileMenu.add(this.jSeparator3);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(this);
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenuItem.setText("Edit Note");
        this.editMenuItem.addActionListener(this);
        this.editMenu.add(this.editMenuItem);
        this.searchMenuItem.setText("Search");
        this.searchMenuItem.addActionListener(this);
        this.editMenu.add(this.searchMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(this);
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.viewMenu.setText("View");
        this.noteMenuItem.setText("Note in new Winow");
        this.noteMenuItem.addActionListener(this);
        this.viewMenu.add(this.noteMenuItem);
        this.menuBar.add(this.viewMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Contents");
        this.contentsMenuItem.addActionListener(this);
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(this);
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.jSplitPane.setDividerLocation(125);
        this.jSplitPane.setOrientation(0);
        this.topPanel.setLayout(new BorderLayout());
        this.treeScroller.setPreferredSize(new Dimension(81, 72));
        this.treeScroller.setViewportView(this.jTree1);
        this.topPanel.add((Component)this.treeScroller, "Center");
        this.jSplitPane.setLeftComponent(this.topPanel);
        this.bottomPanel.setLayout(new BorderLayout(0, 5));
        this.bottomPanel.setBorder(new TitledBorder("Roast Details"));
        this.topInnerPanel.setLayout(new GridLayout(6, 2, 0, 5));
        this.dateLabel.setHorizontalAlignment(0);
        this.dateLabel.setText("Date:");
        this.dateLabel.setToolTipText("The date of the roast.");
        this.topInnerPanel.add(this.dateLabel);
        this.dateField.setBackground(new Color(204, 204, 204));
        this.dateField.setEditable(false);
        this.dateField.setCursor(new Cursor(2));
        this.dateField.setToolTipText("The date of the roast.");
        this.dateField.setBorder(null);
        this.topInnerPanel.add(this.dateField);
        this.typeLabel.setHorizontalAlignment(0);
        this.typeLabel.setText("Type:");
        this.typeLabel.setToolTipText("The type(s and distribution) of bean.");
        this.topInnerPanel.add(this.typeLabel);
        this.typeField.setBackground(new Color(204, 204, 204));
        this.typeField.setEditable(false);
        this.typeField.setCursor(new Cursor(2));
        this.typeField.setToolTipText("The type(s and distribution) of bean.");
        this.typeField.setBorder(null);
        this.topInnerPanel.add(this.typeField);
        this.massLabel.setHorizontalAlignment(0);
        this.massLabel.setText("Mass:");
        this.massLabel.setToolTipText("Amount in grams roasted.");
        this.topInnerPanel.add(this.massLabel);
        this.massField.setBackground(new Color(204, 204, 204));
        this.massField.setEditable(false);
        this.massField.setCursor(new Cursor(2));
        this.massField.setToolTipText("Amount in grams roasted.");
        this.massField.setBorder(null);
        this.topInnerPanel.add(this.massField);
        this.firstLabel.setHorizontalAlignment(0);
        this.firstLabel.setText("First Crack:");
        this.firstLabel.setToolTipText("Time to first crack.");
        this.topInnerPanel.add(this.firstLabel);
        this.firstField.setBackground(new Color(204, 204, 204));
        this.firstField.setEditable(false);
        this.firstField.setCursor(new Cursor(2));
        this.firstField.setToolTipText("Time to first crack.");
        this.firstField.setBorder(null);
        this.topInnerPanel.add(this.firstField);
        this.secondLabel.setHorizontalAlignment(0);
        this.secondLabel.setText("Second Crack:");
        this.secondLabel.setToolTipText("Time to second crack.");
        this.topInnerPanel.add(this.secondLabel);
        this.secondField.setBackground(new Color(204, 204, 204));
        this.secondField.setEditable(false);
        this.secondField.setCursor(new Cursor(2));
        this.secondField.setToolTipText("Time to second crack.");
        this.secondField.setBorder(null);
        this.topInnerPanel.add(this.secondField);
        this.totalLabel.setHorizontalAlignment(0);
        this.totalLabel.setText("Total Time:");
        this.totalLabel.setToolTipText("The total time of the roast.");
        this.topInnerPanel.add(this.totalLabel);
        this.totalField.setBackground(new Color(204, 204, 204));
        this.totalField.setEditable(false);
        this.totalField.setCursor(new Cursor(2));
        this.totalField.setToolTipText("The total time of the roast.");
        this.totalField.setBorder(null);
        this.topInnerPanel.add(this.totalField);
        this.bottomPanel.add((Component)this.topInnerPanel, "North");
        this.bottomInnerPanel.setLayout(new GridLayout(2, 2, 0, 5));
        this.roastLabel.setHorizontalAlignment(0);
        this.roastLabel.setText("Roast Notes:");
        this.roastLabel.setToolTipText("Any other information on the roast process.");
        this.bottomInnerPanel.add(this.roastLabel);
        this.roastTextPane.setBackground(new Color(204, 204, 204));
        this.roastTextPane.setEditable(false);
        this.roastTextPane.setToolTipText("Any other information on the roast process.");
        this.roastScrollPane.setViewportView(this.roastTextPane);
        this.bottomInnerPanel.add(this.roastScrollPane);
        this.tasteLabel.setHorizontalAlignment(0);
        this.tasteLabel.setText("Taste Notes:");
        this.tasteLabel.setToolTipText("Any further comments on the coffee's taste");
        this.bottomInnerPanel.add(this.tasteLabel);
        this.tasteTextPane.setBackground(new Color(204, 204, 204));
        this.tasteTextPane.setEditable(false);
        this.tasteTextPane.setToolTipText("Any further comments on the coffee's taste");
        this.tasteScrollPane.setViewportView(this.tasteTextPane);
        this.bottomInnerPanel.add(this.tasteScrollPane);
        this.bottomPanel.add((Component)this.bottomInnerPanel, "Center");
        this.jSplitPane.setRightComponent(this.bottomPanel);
        pane.add(this.jSplitPane);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 410) / 2, (screenSize.height - 485) / 2, 410, 485);
    }

    public void actionPerformed(ActionEvent evt) {
        Object eventSource = evt.getSource();
        if (eventSource.equals(this.newNoteMenuItem)) {
            this.doNewNote();
        } else if (eventSource.equals(this.newFileMenuItem)) {
            this.doNewFile();
        } else if (eventSource.equals(this.openMenuItem)) {
            this.doOpen();
        } else if (eventSource.equals(this.saveMenuItem)) {
            this.doSave();
        } else if (eventSource.equals(this.saveAsMenuItem)) {
            this.doSaveAs();
        } else if (eventSource.equals(this.publishMenuItem)) {
            this.doPublish();
        } else if (eventSource.equals(this.exitMenuItem)) {
            this.doExit();
        } else if (eventSource.equals(this.editMenuItem)) {
            this.doEdit();
        } else if (eventSource.equals(this.searchMenuItem)) {
            SearchDialog sd = new SearchDialog((Frame)this, false, this.dataController, this.treeBuilder);
            sd.showDialog();
        } else if (eventSource.equals(this.deleteMenuItem)) {
            this.doDelete();
        } else if (eventSource.equals(this.noteMenuItem)) {
            this.doViewNote();
        } else if (eventSource.equals(this.contentsMenuItem)) {
            String helpText = "No help documentation currently exists.\nThe best way to find help is to visit the program's help forum,\n which can be found at http://sourceforge.net/projects/roastlogger\n\nIf you are interested in writing documentation for this program, \ncontact the author <afulton@users.sourceforge.net>";
            JOptionPane.showMessageDialog(this, helpText, "Help wanted ;-)", 1);
        } else if (eventSource.equals(this.aboutMenuItem)) {
            new AboutDialog((Frame)this, true).show();
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        RoastTreeNode node = (RoastTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            Note selectedNote = (Note)node.getUserObject();
            this.setFields(selectedNote);
        } else {
            this.dateField.setText("");
            this.typeField.setText("");
            this.massField.setText("");
            this.firstField.setText("");
            this.secondField.setText("");
            this.totalField.setText("");
            this.roastTextPane.setText("");
            this.tasteTextPane.setText("");
        }
    }

    public void doNewNote() {
        EditDialog ed = new EditDialog((Frame)this, true);
        boolean complete = false;
        do {
            int retval;
            if ((retval = ed.showDialog()) == 1) {
                try {
                    Note newNote = this.dataController.addNote(ed.getInput());
                    this.treeBuilder.addNote(newNote);
                    this.ioController.setModified(true);
                    complete = true;
                }
                catch (ParseException pe) {
                    switch (pe.getErrorOffset()) {
                        case 0: {
                            if (!pe.getMessage().equals("invalid")) break;
                            JOptionPane.showMessageDialog(this, "Date must be in format yyyy/mm/dd", "Error", 0);
                            break;
                        }
                        case 2: {
                            if (!pe.getMessage().equals("invalid")) break;
                            JOptionPane.showMessageDialog(this, "Mass must be a whole number.", "Error", 0);
                            break;
                        }
                        case 3: {
                            if (!pe.getMessage().equals("invalid")) break;
                            JOptionPane.showMessageDialog(this, "First crack time must be in format min:secs.", "Error", 0);
                            break;
                        }
                        case 4: {
                            if (!pe.getMessage().equals("invalid")) break;
                            JOptionPane.showMessageDialog(this, "Second crack time must be in format min:secs.", "Error", 0);
                            break;
                        }
                        case 5: {
                            if (!pe.getMessage().equals("invalid")) break;
                            JOptionPane.showMessageDialog(this, "Total time must be in format min:secs.", "Error", 0);
                        }
                    }
                }
                continue;
            }
            if (retval != 0) continue;
            complete = true;
        } while (!complete);
    }

    public void doNewFile() {
        int retVal;
        if (this.ioController.isModified() && !this.ioController.webMode() && (retVal = JOptionPane.showConfirmDialog(this, "Would you like to save current file first?", "Save current File?", 0)) == 0) {
            this.doSave();
        }
        this.holder = this.dataController.newFile();
        this.jTree1 = this.treeBuilder.buildTree(this.holder);
        this.jTree1.addTreeSelectionListener(this);
        this.treeScroller.setViewportView(this.jTree1);
        this.valueChanged(null);
        this.ioController.setFileName("");
        this.ioController.setModified(false);
        this.ioController.setWebMode(false);
        this.setWebMode(false);
    }

    public void doOpen() {
        FileDialog fd = new FileDialog((Frame)this, true);
        boolean complete = false;
        do {
            int retval;
            if ((retval = fd.showDialog()) == 1) {
                int retVal;
                if (this.ioController.isModified() && !this.ioController.webMode() && (retVal = JOptionPane.showConfirmDialog(this, "Would you like to save current file first?", "Save current File?", 0)) == 0) {
                    this.doSave();
                }
                this.setCursor(new Cursor(3));
                try {
                    this.holder = this.ioController.openFile(fd.getInput());
                }
                catch (Exception e) {
                    this.setCursor(new Cursor(0));
                    JOptionPane.showMessageDialog(this, "The file could not be opened.", "Error Opening File", 0);
                    return;
                }
                this.setCursor(new Cursor(0));
                complete = true;
                this.dataController.setNoteVector(this.holder);
                this.jTree1 = this.treeBuilder.buildTree(this.holder);
                this.jTree1.addTreeSelectionListener(this);
                this.treeScroller.setViewportView(this.jTree1);
                this.valueChanged(null);
                if (this.ioController.webMode()) {
                    this.setWebMode(true);
                    continue;
                }
                this.setWebMode(false);
                continue;
            }
            if (retval != 0) continue;
            complete = true;
        } while (!complete);
    }

    public void doSave() {
        if (!this.ioController.getFileName().equals("")) {
            this.setCursor(new Cursor(3));
            try {
                this.ioController.saveFile(this.holder);
            }
            catch (Exception e) {
                this.setCursor(new Cursor(0));
                JOptionPane.showMessageDialog(this, "The file could not be saved.", "Error Saving File", 0);
            }
            this.setCursor(new Cursor(0));
        } else {
            this.doSaveAs();
        }
    }

    public void doSaveAs() {
        JFileChooser fc = new JFileChooser();
        String oldName = this.ioController.getFileName();
        fc.addChoosableFileFilter(new XMLFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        int retVal = fc.showSaveDialog(this);
        if (retVal == 0) {
            String fileURL = fc.getSelectedFile().getAbsolutePath();
            if (!fileURL.endsWith(".xml")) {
                fileURL = fileURL.concat(".xml");
            }
            this.setCursor(new Cursor(3));
            try {
                this.ioController.setFileName(fileURL);
                this.ioController.saveFile(this.holder);
                this.setWebMode(false);
                this.ioController.setWebMode(false);
            }
            catch (Exception e) {
                this.setCursor(new Cursor(0));
                this.ioController.setFileName(oldName);
                JOptionPane.showMessageDialog(this, "The file could not be saved.", "Error Saving File", 0);
            }
            this.setCursor(new Cursor(0));
        }
    }

    public void doPublish() {
        PublishDialog pd = new PublishDialog((Frame)this, true);
        boolean complete = false;
        do {
            int retval;
            if ((retval = pd.showDialog()) == 1) {
                this.setCursor(new Cursor(3));
                try {
                    this.ioController.publishFile(this.holder, pd.getInput());
                    complete = true;
                }
                catch (Exception e) {
                    this.setCursor(new Cursor(0));
                    JOptionPane.showMessageDialog(this, "The file could not be published.", "Error Publishing File", 0);
                    return;
                }
                this.setCursor(new Cursor(0));
                continue;
            }
            if (retval != 0) continue;
            complete = true;
        } while (!complete);
    }

    public void doExit() {
        int retVal;
        if (this.ioController.isModified() && !this.ioController.webMode() && (retVal = JOptionPane.showConfirmDialog(this, "Would you like to save current file first?", "Save current File?", 0)) == 0) {
            this.doSave();
        }
        System.exit(0);
    }

    public void doEdit() {
        RoastTreeNode node = (RoastTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            Note note = (Note)node.getUserObject();
            EditDialog ed = new EditDialog((Frame)this, true, note);
            boolean complete = false;
            do {
                int retval;
                if ((retval = ed.showDialog()) == 1) {
                    try {
                        Note newNote = this.dataController.editNote(ed.getInput(), note);
                        this.ioController.setModified(true);
                        node.setUserObject(newNote);
                        this.setFields(newNote);
                        complete = true;
                    }
                    catch (ParseException pe) {
                        switch (pe.getErrorOffset()) {
                            case 0: {
                                if (!pe.getMessage().equals("invalid")) break;
                                JOptionPane.showMessageDialog(this, "Date must be in format yyyy/mm/dd", "Error", 0);
                                break;
                            }
                            case 2: {
                                if (!pe.getMessage().equals("invalid")) break;
                                JOptionPane.showMessageDialog(this, "Mass must be a whole number.", "Error", 0);
                                break;
                            }
                            case 3: {
                                if (!pe.getMessage().equals("invalid")) break;
                                JOptionPane.showMessageDialog(this, "First crack time must be in format min:secs.", "Error", 0);
                                break;
                            }
                            case 4: {
                                if (!pe.getMessage().equals("invalid")) break;
                                JOptionPane.showMessageDialog(this, "Second crack time must be in format min:secs.", "Error", 0);
                                break;
                            }
                            case 5: {
                                if (!pe.getMessage().equals("invalid")) break;
                                JOptionPane.showMessageDialog(this, "Total time must be in format min:secs.", "Error", 0);
                            }
                        }
                    }
                    continue;
                }
                if (retval != 0) continue;
                complete = true;
            } while (!complete);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void doDelete() {
        RoastTreeNode node = (RoastTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            int retval = JOptionPane.showConfirmDialog(this, "Are you sure?", "Delete Note", 0);
            if (retval == 0) {
                this.dataController.deleteNote((Note)node.getUserObject());
                this.ioController.setModified(true);
                this.treeBuilder.removeCurrentNode();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void doViewNote() {
        RoastTreeNode node = (RoastTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            new ViewDialog((Frame)this, false, (Note)node.getUserObject()).show();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void setFields(Note selectedNote) {
        this.dateField.setText(selectedNote.getLongDateString());
        this.typeField.setText(selectedNote.getType());
        this.massField.setText(new Integer(selectedNote.getMass()).toString() + "g");
        int minutes = selectedNote.getFirst() / 60;
        int seconds = selectedNote.getFirst() % 60;
        String firstString = minutes + "m" + (seconds < 10 ? "0" : "") + seconds + "s";
        this.firstField.setText(firstString);
        if (selectedNote.getSecond() != -1) {
            minutes = selectedNote.getSecond() / 60;
            seconds = selectedNote.getSecond() % 60;
            String secondString = minutes + "m" + (seconds < 10 ? "0" : "") + seconds + "s";
            this.secondField.setText(secondString);
        } else {
            this.secondField.setText("n/a");
        }
        minutes = selectedNote.getStop() / 60;
        seconds = selectedNote.getStop() % 60;
        String stopString = minutes + "m" + (seconds < 10 ? "0" : "") + seconds + "s";
        this.totalField.setText(stopString);
        this.roastTextPane.setText(selectedNote.getRoast());
        this.tasteTextPane.setText(selectedNote.getTaste());
    }

    private void setWebMode(boolean b) {
        if (b) {
            this.newNoteMenuItem.setEnabled(false);
            this.saveMenuItem.setEnabled(false);
            this.publishMenuItem.setEnabled(false);
            this.editMenuItem.setEnabled(false);
            this.deleteMenuItem.setEnabled(false);
        } else {
            this.newNoteMenuItem.setEnabled(true);
            this.saveMenuItem.setEnabled(true);
            this.publishMenuItem.setEnabled(true);
            this.editMenuItem.setEnabled(true);
            this.deleteMenuItem.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        new Main().show();
    }
}

