/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.roastlogger.control.UserInputHolder;
import org.roastlogger.gui.XMLFileFilter;

public class PublishDialog
extends JDialog
implements ActionListener {
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    private int option = -1;
    private UserInputHolder inputHolder = new UserInputHolder();
    private String fileURL;
    private Container pane;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JPanel saveFilePanel;
    private JTextPane infoTextPane;
    private JLabel saveFileLabel;
    private JTextField fileLocationTextField;
    private JButton browseButton;
    private JButton okButton;
    private JButton cancelButton;

    public PublishDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.pane = this.getContentPane();
        this.mainPanel = new JPanel();
        this.infoTextPane = new JTextPane();
        this.saveFilePanel = new JPanel();
        this.saveFileLabel = new JLabel();
        this.fileLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.bottomPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Publish");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PublishDialog.this.option = 0;
                PublishDialog.this.closeDialog();
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        this.infoTextPane.setBackground(new Color(204, 204, 204));
        this.infoTextPane.setEditable(false);
        this.infoTextPane.setFont(new Font("Dialog", 1, 12));
        this.infoTextPane.setText("Note: This feature prepares the xml log file for publication on the web.\n\nChoose a location on disk to save to, and the resulting file will be ready to be manually upload to your website.");
        this.mainPanel.add((Component)this.infoTextPane, "Center");
        this.saveFilePanel.setLayout(new FlowLayout());
        this.saveFileLabel.setText("Save File To: ");
        this.saveFilePanel.add(this.saveFileLabel);
        this.fileLocationTextField.setPreferredSize(new Dimension(200, 20));
        this.saveFilePanel.add(this.fileLocationTextField);
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(this);
        this.saveFilePanel.add(this.browseButton);
        this.mainPanel.add((Component)this.saveFilePanel, "South");
        this.pane.add((Component)this.mainPanel, "Center");
        this.okButton.setText("Ok");
        this.okButton.addActionListener(this);
        this.bottomPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.bottomPanel.add(this.cancelButton);
        this.pane.add((Component)this.bottomPanel, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 215) / 2, 400, 215);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.option;
    }

    public UserInputHolder getInput() {
        return this.inputHolder;
    }

    public void actionPerformed(ActionEvent evt) {
        Object eventSource = evt.getSource();
        if (eventSource.equals(this.browseButton)) {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(new XMLFileFilter());
            fc.setAcceptAllFileFilterUsed(false);
            int retVal = fc.showSaveDialog(this);
            if (retVal == 0) {
                this.fileURL = fc.getSelectedFile().getAbsolutePath();
                this.fileLocationTextField.setText(this.fileURL);
            }
        } else if (eventSource.equals(this.okButton)) {
            this.option = 1;
            this.inputHolder.setFileLocation(this.fileLocationTextField.getText());
            this.setVisible(false);
        } else {
            this.option = 0;
            this.closeDialog();
        }
    }
}

