/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.roastlogger.control.DataController;
import org.roastlogger.control.UserInputHolder;
import org.roastlogger.datastructures.Note;
import org.roastlogger.gui.tree.TreeBuilder;

public class SearchDialog
extends JDialog
implements ActionListener {
    private UserInputHolder inputHolder = new UserInputHolder();
    private UserInputHolder lastSearchHolder = new UserInputHolder();
    private DataController dataController;
    private TreeBuilder treeBuilder;
    private Container pane;
    private JPanel spacerPanel;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JLabel typeLabel;
    private JLabel massLabel;
    private JLabel roastLabel;
    private JLabel tasteLabel;
    private JTextField typeTextField;
    private JTextField massTextField;
    private JTextField roastTextField;
    private JTextField tasteTextField;
    private JButton findButton;
    private JButton cancelButton;

    public SearchDialog(Frame parent, boolean modal, DataController control, TreeBuilder tb) {
        super(parent, modal);
        this.dataController = control;
        this.treeBuilder = tb;
        this.initComponents();
    }

    private void initComponents() {
        this.pane = this.getContentPane();
        this.spacerPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.typeLabel = new JLabel();
        this.typeTextField = new JTextField();
        this.massLabel = new JLabel();
        this.massTextField = new JTextField();
        this.roastLabel = new JLabel();
        this.roastTextField = new JTextField();
        this.tasteLabel = new JLabel();
        this.tasteTextField = new JTextField();
        this.bottomPanel = new JPanel();
        this.findButton = new JButton();
        this.cancelButton = new JButton();
        this.pane.setLayout(new BorderLayout(0, 5));
        this.setTitle("Search");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SearchDialog.this.closeDialog();
            }
        });
        this.pane.add((Component)this.spacerPanel, "North");
        this.mainPanel.setLayout(new GridLayout(4, 2, 0, 5));
        this.mainPanel.setBorder(new EmptyBorder(new Insets(1, 5, 1, 5)));
        this.typeLabel.setHorizontalAlignment(0);
        this.typeLabel.setText("Type:");
        this.mainPanel.add(this.typeLabel);
        this.mainPanel.add(this.typeTextField);
        this.massLabel.setHorizontalAlignment(0);
        this.massLabel.setText("Mass (grams):");
        this.mainPanel.add(this.massLabel);
        this.mainPanel.add(this.massTextField);
        this.roastLabel.setHorizontalAlignment(0);
        this.roastLabel.setText("In Roast Notes:");
        this.mainPanel.add(this.roastLabel);
        this.mainPanel.add(this.roastTextField);
        this.tasteLabel.setHorizontalAlignment(0);
        this.tasteLabel.setText("In Taste Notes:");
        this.mainPanel.add(this.tasteLabel);
        this.mainPanel.add(this.tasteTextField);
        this.pane.add((Component)this.mainPanel, "Center");
        this.findButton.setText("Find Next");
        this.findButton.addActionListener(this);
        this.bottomPanel.add(this.findButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.bottomPanel.add(this.cancelButton);
        this.pane.add((Component)this.bottomPanel, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 460) / 2, (screenSize.height - 190) / 2, 460, 190);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent evt) {
        Object eventSource = evt.getSource();
        if (eventSource.equals(this.findButton)) {
            Note foundNote = null;
            this.inputHolder.setType(this.typeTextField.getText());
            this.inputHolder.setMass(this.massTextField.getText());
            this.inputHolder.setRoast(this.roastTextField.getText());
            this.inputHolder.setTaste(this.tasteTextField.getText());
            if (!this.inputHolder.equals(this.lastSearchHolder)) {
                this.dataController.newSearch();
            }
            this.lastSearchHolder = (UserInputHolder)this.inputHolder.clone();
            try {
                foundNote = this.dataController.findNext(this.inputHolder);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "Invalid entry for mass entered", "Error: Invalid details entered", 0);
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showMessageDialog(this, "No search criteria entered", "Error: No details entered", 0);
            }
            if (foundNote != null) {
                this.treeBuilder.selectNode(foundNote);
            } else {
                JOptionPane.showMessageDialog(this, "Finished searching the logs", "Error: No log found", 1);
            }
        } else {
            this.closeDialog();
        }
    }
}

