/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.roastlogger.datastructures.Note;

public class ViewDialog
extends JDialog {
    private Container pane;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JPanel topMainPanel;
    private JPanel bottomMainPanel;
    private JLabel titleLabel;
    private JLabel dateLabel;
    private JLabel dateText;
    private JLabel typeLabel;
    private JLabel typeText;
    private JLabel massLabel;
    private JLabel massText;
    private JLabel firstLabel;
    private JLabel firstText;
    private JLabel secondLabel;
    private JLabel secondText;
    private JLabel totalLabel;
    private JLabel totalText;
    private JLabel roastLabel;
    private JLabel tasteLabel;
    private JScrollPane roastScrollPane;
    private JScrollPane tasteScrollPane;
    private JTextPane roastTextPane;
    private JTextPane tasteTextPane;
    private JButton okButton;

    public ViewDialog(Frame parent, boolean modal, Note note) {
        super(parent, modal);
        this.initComponents(note);
    }

    private void initComponents(Note note) {
        this.pane = this.getContentPane();
        this.titleLabel = new JLabel();
        this.mainPanel = new JPanel();
        this.topMainPanel = new JPanel();
        this.dateLabel = new JLabel();
        this.dateText = new JLabel();
        this.typeLabel = new JLabel();
        this.typeText = new JLabel();
        this.massLabel = new JLabel();
        this.massText = new JLabel();
        this.firstLabel = new JLabel();
        this.firstText = new JLabel();
        this.secondLabel = new JLabel();
        this.secondText = new JLabel();
        this.totalLabel = new JLabel();
        this.totalText = new JLabel();
        this.bottomMainPanel = new JPanel();
        this.roastLabel = new JLabel();
        this.roastScrollPane = new JScrollPane();
        this.roastTextPane = new JTextPane();
        this.tasteLabel = new JLabel();
        this.tasteScrollPane = new JScrollPane();
        this.tasteTextPane = new JTextPane();
        this.bottomPanel = new JPanel();
        this.okButton = new JButton();
        this.pane.setLayout(new BorderLayout(0, 5));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ViewDialog.this.closeDialog();
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("Roast Details");
        this.pane.add((Component)this.titleLabel, "North");
        this.mainPanel.setLayout(new BorderLayout(0, 5));
        this.mainPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 5)));
        this.topMainPanel.setLayout(new GridLayout(6, 2, 0, 5));
        this.dateLabel.setHorizontalAlignment(0);
        this.dateLabel.setText("Date:");
        this.topMainPanel.add(this.dateLabel);
        this.dateText.setFont(new Font("Dialog", 0, 12));
        this.dateText.setText(note.getLongDateString());
        this.topMainPanel.add(this.dateText);
        this.typeLabel.setHorizontalAlignment(0);
        this.typeLabel.setText("Type:");
        this.topMainPanel.add(this.typeLabel);
        this.typeText.setFont(new Font("Dialog", 0, 12));
        this.typeText.setText(note.getType());
        this.topMainPanel.add(this.typeText);
        this.massLabel.setHorizontalAlignment(0);
        this.massLabel.setText("Mass:");
        this.topMainPanel.add(this.massLabel);
        this.massText.setFont(new Font("Dialog", 0, 12));
        this.massText.setText(note.getMass() + "g");
        this.topMainPanel.add(this.massText);
        this.firstLabel.setHorizontalAlignment(0);
        this.firstLabel.setText("First Crack:");
        this.topMainPanel.add(this.firstLabel);
        int minutes = note.getFirst() / 60;
        int seconds = note.getFirst() % 60;
        String firstString = minutes + "m" + (seconds < 10 ? "0" : "") + seconds + "s";
        this.firstText.setFont(new Font("Dialog", 0, 12));
        this.firstText.setText(firstString);
        this.topMainPanel.add(this.firstText);
        this.secondLabel.setHorizontalAlignment(0);
        this.secondLabel.setText("Second Crack:");
        this.topMainPanel.add(this.secondLabel);
        this.secondText.setFont(new Font("Dialog", 0, 12));
        if (note.getSecond() != -1) {
            minutes = note.getSecond() / 60;
            seconds = note.getSecond() % 60;
            String secondString = minutes + "m" + (seconds < 10 ? "0" : "") + seconds + "s";
            this.secondText.setText(secondString);
        } else {
            this.secondText.setText("n/a");
        }
        this.topMainPanel.add(this.secondText);
        this.totalLabel.setHorizontalAlignment(0);
        this.totalLabel.setText("Total Time:");
        this.topMainPanel.add(this.totalLabel);
        minutes = note.getStop() / 60;
        seconds = note.getStop() % 60;
        String stopString = minutes + "m" + (seconds < 10 ? "0" : "") + seconds + "s";
        this.totalText.setFont(new Font("Dialog", 0, 12));
        this.totalText.setText(stopString);
        this.topMainPanel.add(this.totalText);
        this.mainPanel.add((Component)this.topMainPanel, "North");
        this.bottomMainPanel.setLayout(new GridLayout(2, 2));
        this.roastLabel.setHorizontalAlignment(0);
        this.roastLabel.setText("Roast Notes:");
        this.bottomMainPanel.add(this.roastLabel);
        this.roastTextPane.setBackground(new Color(204, 204, 204));
        this.roastTextPane.setEditable(false);
        this.roastTextPane.setText(note.getRoast());
        this.roastScrollPane.setViewportView(this.roastTextPane);
        this.bottomMainPanel.add(this.roastScrollPane);
        this.tasteLabel.setHorizontalAlignment(0);
        this.tasteLabel.setText("Taste Notes:");
        this.bottomMainPanel.add(this.tasteLabel);
        this.tasteTextPane.setBackground(new Color(204, 204, 204));
        this.tasteTextPane.setEditable(false);
        this.tasteTextPane.setText(note.getTaste());
        this.tasteScrollPane.setViewportView(this.tasteTextPane);
        this.bottomMainPanel.add(this.tasteScrollPane);
        this.mainPanel.add((Component)this.bottomMainPanel, "Center");
        this.pane.add((Component)this.mainPanel, "Center");
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.closeDialog();
            }
        });
        this.bottomPanel.add(this.okButton);
        this.pane.add((Component)this.bottomPanel, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 415) / 2, (screenSize.height - 425) / 2, 415, 425);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

