/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.gui.tree;

import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.roastlogger.datastructures.Note;
import org.roastlogger.datastructures.NoteVector;
import org.roastlogger.gui.tree.RoastTreeNode;

public class TreeBuilder {
    JTree tree;
    DefaultTreeModel treeModel;
    RoastTreeNode rootNode;

    public TreeBuilder() {
        this.buildTree(null);
    }

    public TreeBuilder(NoteVector holder) {
        this.buildTree(holder);
    }

    public JTree getTree() {
        return this.tree;
    }

    public JTree buildTree(NoteVector holder) {
        this.rootNode = new RoastTreeNode("Roasts");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        Vector<RoastTreeNode> years = new Vector<RoastTreeNode>();
        GregorianCalendar cal = new GregorianCalendar();
        if (holder != null) {
            int j;
            int year;
            int i;
            for (i = 0; i < holder.size(); ++i) {
                RoastTreeNode target = new RoastTreeNode(-1, -1);
                Note currentNote = (Note)holder.get(i);
                cal.setTime(currentNote.getDate());
                year = cal.get(1);
                for (j = 0; j < years.size(); ++j) {
                    RoastTreeNode currentYearNode = (RoastTreeNode)years.get(j);
                    if (currentYearNode.getYear() != year) continue;
                    target = currentYearNode;
                }
                if (target.getYear() == -1) {
                    target = new RoastTreeNode(year, -1);
                    target.setUserObject(new Integer(year));
                    years.add(target);
                }
                target.add(new RoastTreeNode(currentNote));
            }
            for (i = 0; i < years.size(); ++i) {
                RoastTreeNode[] months = new RoastTreeNode[12];
                RoastTreeNode currentYearNode = (RoastTreeNode)years.get(i);
                for (j = 0; j < currentYearNode.getChildCount(); ++j) {
                    RoastTreeNode currentNode = (RoastTreeNode)currentYearNode.getChildAt(j);
                    Note currentNote = (Note)currentNode.getUserObject();
                    cal.setTime(currentNote.getDate());
                    year = cal.get(1);
                    int month = cal.get(2);
                    if (months[month] == null) {
                        months[month] = new RoastTreeNode(year, month);
                        months[month].setUserObject(this.getMonthString(month) + " " + year);
                    }
                    months[month].add(currentNode);
                    --j;
                }
                for (int k = 0; k < months.length; ++k) {
                    if (months[k] == null) continue;
                    currentYearNode.add(months[k]);
                }
            }
            for (i = 0; i < years.size(); ++i) {
                this.rootNode.add((RoastTreeNode)years.get(i));
            }
        }
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        return this.tree;
    }

    public RoastTreeNode addNote(Note child) {
        int i;
        Object parent = null;
        RoastTreeNode current = null;
        RoastTreeNode target = null;
        RoastTreeNode yearNode = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(child.getDate());
        int year = cal.get(1);
        for (i = 0; i < this.rootNode.getChildCount(); ++i) {
            current = (RoastTreeNode)this.rootNode.getChildAt(i);
            if (current.getYear() != year) continue;
            yearNode = current;
        }
        if (yearNode == null) {
            yearNode = new RoastTreeNode(year, -1);
            yearNode.setUserObject(new Integer(year));
            this.treeModel.insertNodeInto(yearNode, this.rootNode, this.rootNode.getChildCount());
        }
        int month = cal.get(2);
        for (i = 0; i < yearNode.getChildCount(); ++i) {
            current = (RoastTreeNode)yearNode.getChildAt(i);
            if (current.getMonth() != month) continue;
            target = current;
        }
        if (target == null) {
            target = new RoastTreeNode(year, month);
            target.setUserObject(this.getMonthString(month) + " " + year);
            this.treeModel.insertNodeInto(target, yearNode, yearNode.getChildCount());
        }
        RoastTreeNode childNode = new RoastTreeNode(child);
        this.treeModel.insertNodeInto(childNode, target, target.getChildCount());
        this.tree.setSelectionPath(new TreePath(childNode.getPath()));
        this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        return childNode;
    }

    public void removeCurrentNode() {
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null) {
            RoastTreeNode currentNode = (RoastTreeNode)currentSelection.getLastPathComponent();
            this.removeNode(currentNode);
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public void removeNode(RoastTreeNode rtn) {
        RoastTreeNode parent = (RoastTreeNode)rtn.getParent();
        if (parent != null) {
            this.treeModel.removeNodeFromParent(rtn);
            if (parent.getChildCount() == 0) {
                this.removeNode(parent);
            }
        }
    }

    public void selectNode(Note foundNote) {
        TreePath path = null;
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            RoastTreeNode aNode = (RoastTreeNode)enumeration.nextElement();
            if (aNode.getUserObject() != foundNote) continue;
            path = new TreePath(aNode.getPath());
        }
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    private String getMonthString(int month) {
        String monthString = null;
        switch (month) {
            case 0: {
                monthString = "January";
                break;
            }
            case 1: {
                monthString = "February";
                break;
            }
            case 2: {
                monthString = "March";
                break;
            }
            case 3: {
                monthString = "April";
                break;
            }
            case 4: {
                monthString = "May";
                break;
            }
            case 5: {
                monthString = "June";
                break;
            }
            case 6: {
                monthString = "July";
                break;
            }
            case 7: {
                monthString = "August";
                break;
            }
            case 8: {
                monthString = "September";
                break;
            }
            case 9: {
                monthString = "October";
                break;
            }
            case 10: {
                monthString = "November";
                break;
            }
            case 11: {
                monthString = "December";
            }
        }
        return monthString;
    }
}

