/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.xmlio;

import java.io.IOException;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.roastlogger.datastructures.Note;
import org.roastlogger.datastructures.NoteVector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LogReader
extends DefaultHandler {
    private ElementData element;
    private Note note;
    private NoteVector noteHolder;
    private boolean currElIsNote;
    private boolean topLevel;

    public void startDocument() throws SAXException {
        this.noteHolder = new NoteVector();
        this.topLevel = true;
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String elementName = sName;
        if (elementName.equals("")) {
            elementName = qName;
        }
        if (elementName == "note") {
            int indexNumber;
            this.topLevel = false;
            this.currElIsNote = true;
            try {
                indexNumber = Integer.parseInt(attrs.getValue(0));
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("idx must be an integer", nfe);
            }
            this.note = new Note(indexNumber);
        } else if (!this.topLevel) {
            this.currElIsNote = false;
            this.element = new ElementData(elementName);
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (!this.currElIsNote && !this.topLevel) {
            String s = new String(buf, offset, len);
            s = s.trim();
            this.element.setData(this.element.getData().concat(s));
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String elementName = sName;
        if (elementName.equals("")) {
            elementName = qName;
        }
        String data = this.element.getData();
        if (elementName.equals("note")) {
            this.noteHolder.add(this.note.getIndex(), this.note);
        }
        if (elementName == "date") {
            try {
                this.note.setDate(data);
            }
            catch (ParseException pe) {
                throw new SAXException("Invalid Date Format", pe);
            }
        } else if (elementName == "type") {
            this.note.setType(data);
        } else if (elementName == "mass") {
            try {
                this.note.setMass(data);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("Invalid Mass format", nfe);
            }
        } else if (elementName == "first") {
            try {
                this.note.setFirst(data);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("Invalid time in seconds", nfe);
            }
        } else if (elementName == "second") {
            try {
                this.note.setSecond(data);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("Invalid time in seconds", nfe);
            }
        } else if (elementName == "stop") {
            try {
                this.note.setStop(data);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("Invalid time in seconds", nfe);
            }
        } else if (elementName == "roast") {
            this.note.setRoastNote(data);
        } else if (elementName == "taste") {
            this.note.setTasteNote(data);
        }
    }

    public void error(SAXParseException spe) throws SAXParseException {
        throw spe;
    }

    public void warning(SAXParseException err) throws SAXParseException {
        System.out.println("** Warning, line " + err.getLineNumber());
        System.out.println("   " + err.getMessage());
    }

    public NoteVector getNotes(String location) throws SAXParseException, SAXException, ParserConfigurationException, IOException {
        LogReader handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(location), (DefaultHandler)handler);
        }
        catch (SAXParseException spe) {
            throw spe;
        }
        catch (SAXException se) {
            throw se;
        }
        catch (ParserConfigurationException pce) {
            throw pce;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return this.noteHolder;
    }

    class ElementData {
        private String name;
        private String data;

        public ElementData() {
            this.name = "";
            this.data = "";
        }

        public ElementData(String eName) {
            this.name = eName;
            this.data = "";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String eName) {
            this.name = eName;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String eData) {
            this.data = eData;
        }
    }
}

