/*
 * Decompiled with CFR 0.152.
 */
package org.roastlogger.xmlio;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.roastlogger.datastructures.Note;

public class LogWriter {
    private PrintWriter outFile;
    private boolean fileOpen;

    public void openFile(String fileName) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        this.outFile = new PrintWriter(new BufferedWriter(fw));
        this.fileOpen = true;
    }

    public void writeHeader(String dtdLocation) throws IOException {
        if (!this.fileOpen) {
            throw new IOException("File is not open for writing!");
        }
        this.outFile.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.outFile.println("<!DOCTYPE roastlog SYSTEM \"" + dtdLocation + "\">");
        this.outFile.println();
        this.outFile.println("<roastlog>");
    }

    public void writeNote(Note note) throws IOException {
        if (!this.fileOpen) {
            throw new IOException("File is not open for writing!");
        }
        this.outFile.println();
        this.outFile.println("  <note roastidx=\"" + note.getIndex() + "\">");
        this.outFile.println("    <date>" + note.getShortDateString() + "</date>");
        this.outFile.println("    <type>" + note.getType() + "</type>");
        this.outFile.println("    <mass>" + note.getMass() + "</mass>");
        this.outFile.println("    <first>" + note.getFirst() + "</first>");
        if (note.getSecond() != -1) {
            this.outFile.println("    <second>" + note.getSecond() + "</second>");
        }
        this.outFile.println("    <stop>" + note.getStop() + "</stop>");
        if (note.getRoast() != "") {
            this.outFile.println("    <roast>");
            this.outFile.println(note.getRoast());
            this.outFile.println("    </roast>");
        }
        if (note.getTaste() != "") {
            this.outFile.println("    <taste>");
            this.outFile.println(note.getTaste());
            this.outFile.println("    </taste>");
        }
        this.outFile.println("  </note>");
    }

    public void writeFooter() {
        this.outFile.println("</roastlog>");
    }

    public void closeFile() {
        if (this.fileOpen) {
            this.outFile.close();
            this.fileOpen = false;
        }
    }
}

